#' Delete sections in config, just do config[sections] <- NULL
#'
#' @param config a list of config (eg. generated by read.config)
#' @param sections Sections that need to be deleted
#' @return 
#' A list of config
#' @export
#' @examples
#' config.json <- system.file('extdata', 'config.json', package = 'configr')
#' config <- read.config(config.json, file.type = 'json')
#' config <- config.sections.del(config, 'default')
config.sections.del <- function(config, sections) {
  config[sections] <- NULL
  return(config)
}
