% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_measures_of_location.R
\name{ci_quantile}
\alias{ci_quantile}
\title{CI for a Population Quantile}
\usage{
ci_quantile(
  x,
  q = 0.5,
  probs = c(0.025, 0.975),
  type = c("binomial", "bootstrap"),
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{q}{A single probability value determining the quantile.
Set to 0.5 for the median (the default).}

\item{probs}{Lower and upper probabilities, by default c(0.025, 0.975).}

\item{type}{Type of CI. One of "binomial" (default), or "bootstrap".}

\item{boot_type}{Type of bootstrap CI ("bca", "perc", "norm", "basic").
Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{boot::boot()}.}
}
\value{
An object of class "cint" containing these components:
\itemize{
\item \code{parameter}: Parameter specification.
\item \code{interval}: CI for the parameter.
\item \code{estimate}: Parameter estimate.
\item \code{probs}: Lower and upper probabilities.
\item \code{type}: Type of interval.
\item \code{info}: Additional description.
}
}
\description{
This function calculates CIs for a population quantile. By default, distribution-free
CIs based on the binomial distribution are calculated, see Hahn and Meeker.
Alternatively, bootstrap CIs are available (by default "bca").
}
\examples{
x <- 1:100
ci_quantile(x, q = 0.25)
}
\references{
Hahn, G. and Meeker, W. (1991). Statistical Intervals. Wiley 1991.
}
\seealso{
\code{\link{ci_quantile}}.
}
