% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cham_bills.R
\name{cham_bills}
\alias{cham_bills}
\title{Downloads and tidies data for lists of bills in Brazilian Chamber of Deputies}
\usage{
cham_bills(type = "", number = "", year = "", initial_date = "",
  end_date = "", part_name_author = "", id_type_author = "",
  abbreviation_party_author = "", abbreviation_st_author = "",
  gender_author = "", cod_state = "", cod_branch_state = "", still = "",
  ascii = T)
}
\arguments{
\item{type}{\code{character}. The type of the bill. For example, "PL"}

\item{number}{\code{integer}. The number of the bill}

\item{year}{\code{integer}. The year of the bill.}

\item{initial_date}{(\code{character}) start date of the period requested.
This parameter must be in the format YYYYMMDD (Year-Month-Day). A value for
this parameter is necessary, all others are optional.}

\item{end_date}{(\code{character}) final date for period requested. Format
YYYYMMDD.}

\item{part_name_author}{(\code{character}). Filter bills by a part of the author's name}

\item{id_type_author}{(\code{character}). Filter bills by type of a branch_author for the bill.}

\item{abbreviation_party_author}{(\code{character}). Filter bills by the party of the author}

\item{abbreviation_st_author}{(\code{character}). Filter bills by the state of the author}

\item{gender_author}{(\code{character}). If "M", bills proposed by male authors are filtered. If "F", female authors. If empty, every bill is included.}

\item{cod_state}{(\code{integer}). Filter bills by a part of the author's name}

\item{cod_branch_state}{(\code{integer}). Filter by the id of the branch regarding the bill.}

\item{still}{(\code{integer}). If 1, only bills that are still being discussed are included. If 2, only ended bills. If empty, every bill is included.}

\item{ascii}{\code{logical}. If TRUE, certain strings are converted to ascii
format.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Downloads and tidies data for lists of bills in Brazilian Chamber of Deputies
}
\note{
Requesting data from a long period of time with \code{details = TRUE} will
return a large object in terms of memory. It will also be rather unwieldy, with
many columns.
}
\examples{
\dontrun{
cham_bills(type = "PL", year = 1998)
}
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
