% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sen_plenary.R
\name{sen_plenary_agenda}
\alias{sen_plenary_agenda}
\title{Returns results from the plenary in the Federal Senate for a
specified date}
\usage{
sen_plenary_agenda(period = c("month", "day"), date = NULL, ascii = TRUE)
}
\arguments{
\item{period}{\code{character}. If "month" is selected, all information
available from the date specified with \code{date} to the end of the month
is returned. Otherwise, information returned from the day of \code{date} only
is returned.}

\item{date}{\code{character}. Format YYYYMMDD.}

\item{ascii}{\code{logical}. If \code{TRUE}, the default, strips Latin
characters from the results.}
}
\value{
A tibble, of classes \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
Returns results from the plenary in the Federal Senate for a
specified date.
}
\examples{
# get info from the second half of March 2014:
sessions <- sen_plenary_agenda(period = "month", date = "20140315")
# or from the first of April 2016:
sessions <- sen_plenary_agenda(period = "day", date = "20160401")
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
