% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_users}
\alias{get_users}
\title{Get user information from the Posit Connect server}
\usage{
get_users(src, page_size = 20, prefix = NULL, limit = 25)
}
\arguments{
\item{src}{The source object}

\item{page_size}{the number of records to return per page (max 500)}

\item{prefix}{Filters users by prefix (username, first name, or last name).
The filter is case insensitive.}

\item{limit}{The max number of records to return}
}
\value{
A tibble with the following columns:
\itemize{
\item{\strong{email}}{The user's email}
\item{\strong{username}}{The user's username}
\item{\strong{first_name}}{The user's first name}
\item{\strong{last_name}}{The user's last name}
\item{\strong{user_role}}{The user's role. It may have a value of
administrator, publisher or viewer.}
\item{\strong{created_time}}{The timestamp (in RFC3339 format) when the
user was created in the Posit Connect server}
\item{\strong{updated_time}}{The timestamp (in RFC3339 format) when the
user was last updated in the Posit Connect server}
\item{\strong{active_time}}{The timestamp (in RFC3339 format) when the
user was last active on the Posit Connect server}
\item{\strong{confirmed}}{When false, the created user must confirm their
account through an email. This feature is unique to password
authentication.}
\item{\strong{locked}}{Whether or not the user is locked}
\item{\strong{guid}}{The user's GUID, or unique identifier, in UUID RFC4122 format}
}
}
\description{
Get user information from the Posit Connect server
}
\details{
Please see https://docs.posit.co/connect/api/#getUsers for more information
}
\examples{
\dontrun{
library(connectapi)
client <- connect()

# get all users
get_users(client, limit = Inf)
}

}
