% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsc_cols.R
\name{rsc_cols}
\alias{rsc_cols}
\title{Arrange HTML elements or widgets in Bootstrap columns}
\usage{
rsc_cols(..., widths = NA, device = c("xs", "sm", "md", "lg"))
}
\arguments{
\item{...}{\code{htmltools} tag objects, lists, text, HTML widgets, or
NULL. These arguments should be unnamed.}

\item{widths}{The number of columns that should be assigned to each of the
\code{...} elements (the total number of columns available is always 12).
The width vector will be recycled if there are more \code{...} arguments.
\code{NA} columns will evenly split the remaining columns that are left
after the widths are recycled and non-\code{NA} values are subtracted.}

\item{device}{The class of device which is targeted by these widths; with
smaller screen sizes the layout will collapse to a one-column,
top-to-bottom display instead. xs: never collapse, sm: collapse below
768px, md: 992px, lg: 1200px.}
}
\value{
A \code{\link[htmltools]{browsable}} HTML element.
}
\description{
This helper function makes it easy to put HTML elements side by side. It can
be called directly from the console but is especially designed to work in an
R Markdown document. Note that this is ripped directly from
https://github.com/rstudio/crosstalk without the additional bootstrap
dependency (since it is already expected in connectwidgets)
}
\examples{
\donttest{
library(htmltools)

# If width is unspecified, equal widths will be used
rsc_cols(
  div(style = css(width="100\%", height="400px", background_color="red")),
  div(style = css(width="100\%", height="400px", background_color="blue"))
)

# Use NA to absorb remaining width
rsc_cols(widths = c(2, NA, NA),
  div(style = css(width="100\%", height="400px", background_color="red")),
  div(style = css(width="100\%", height="400px", background_color="blue")),
  div(style = css(width="100\%", height="400px", background_color="green"))
)

# Recycling widths
rsc_cols(widths = c(2, 4),
  div(style = css(width="100\%", height="400px", background_color="red")),
  div(style = css(width="100\%", height="400px", background_color="blue")),
  div(style = css(width="100\%", height="400px", background_color="red")),
  div(style = css(width="100\%", height="400px", background_color="blue"))
)
}
}
