% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potentialDurations.R
\name{potentialDurations}
\alias{potentialDurations}
\title{Identify Potential Contact Durations}
\usage{
potentialDurations(
  x,
  blocking = FALSE,
  blockLength = 1,
  blockUnit = "hours",
  distFunction = "dist2All_df"
)
}
\arguments{
\item{x}{Output from the dist2All or dist2Area function. Can be either a 
data frame or non-data-frame list.}

\item{blocking}{Logical. If TRUE, contacts will be evaluated for temporal 
blocks spanning blockLength blockUnit (e.g., 6 hours) within the data 
set. Defaults to FALSE.}

\item{blockLength}{Integer. Describes the number blockUnits within each 
temporal block. Defaults to 1.}

\item{blockUnit}{Character string taking the values: "secs," "mins," 
"hours," "days," or "weeks." Describes the temporal unit associated with
each block. Defaults to "hours."}

\item{distFunction}{Character string taking the values: "dist2All_df",
or "dist2Area_df." Describes the contact-package function used to
generate x.}
}
\value{
Returns a data frame (or list of data frames if \code{x} is a 
   list of data frames) with the following columns:
   
   \item{id}{The unique ID of an individual observed in the data set.}
   \item{potenDegree}{The maximum degree possible for individual \code{id} 
   based on the number of other individuals observed during the time 
   period.}
   \item{potenTotalContactDurations}{The maximum number of contact durations 
   individual \code{id} may experience during the time period.}    
   \item{potenContactDurations_...}{The maximum number of contact durations 
   individual \code{id} may experience with each specific individual/fixed 
   area during the time period.}
   
   If blocking == TRUE, the following columns are appended to the output
   data frame described above:
   
   \item{block}{Integer ID describing unique blocks of time during which 
   contacts may occur.}
   \item{block.start}{The timepoint in \code{x} at which the \code{block}
   begins.}
   \item{block.end}{The timepoint in \code{x} at which the \code{block}
   ends.}
}
\description{
This function uses the output from dist2All to determine the potential 
   maximum number of direct-contact durations between individuals in a data 
   set. The max number of durations potentially observed is the number of 
   TSWs both individuals (or an individual and fixed area) were observed at 
   the same time over the study period/temporal block. The output of this 
   function is required for using the "chisq" test argument in the 
   contactTest function.
}
\examples{

data(calves)

calves.dateTime<-datetime.append(calves, date = calves$date, time =
    calves$time) #create a dataframe with dateTime identifiers for location foxes
    
calves.agg<-tempAggregate(calves.dateTime, id = calves.dateTime$calftag,
    dateTime = calves.dateTime$dateTime, point.x = calves.dateTime$x,
    point.y = calves.dateTime$y, secondAgg = 300, extrapolate.left = FALSE,
    extrapolate.right = FALSE, resolutionLevel = "reduced", parallel = FALSE,
    na.rm = TRUE, smooth.type = 1) #smooth locations to 5-min fix intervals.

calves.dist<-dist2All_df(x = calves.agg, parallel = FALSE, dataType = "Point",
    lonlat = FALSE) #calculate distance between all individuals at each timepoint
    
calves.potentialContacts<-potentialDurations(x = calves.dist, blocking = FALSE)
}
\keyword{contact}
\keyword{data-processing}
