## ----knitr-setup, include = FALSE-----------------------------------------------------------------
unloadNamespace("dplyr")
require(container)
has = container::has
has_name = container::has_name


knitr::opts_chunk$set(
  comment = "#",
  prompt = F,
  tidy = FALSE,
  cache = FALSE,
  collapse = T
)

options(width = 100L)

## -------------------------------------------------------------------------------------------------
library(container)
co = cont(a = 1, b = 1:10)  # same as co = container(a = 1, b = 1:10)

## -------------------------------------------------------------------------------------------------
print(co)

## -------------------------------------------------------------------------------------------------
as.list(co)

## -------------------------------------------------------------------------------------------------
str(co)

## -------------------------------------------------------------------------------------------------
length(co)

names(co)

names(co)[1] <- "A"
co

## -------------------------------------------------------------------------------------------------
l = list(x = (1:2)^1, y = (1:2)^2)
co2 = as.container(l)
co2

## -------------------------------------------------------------------------------------------------
c(co, co2)

## -------------------------------------------------------------------------------------------------
co[["c"]] <- 3
co

## -------------------------------------------------------------------------------------------------
co[["co2"]] <- co2
co

## ---- error = TRUE--------------------------------------------------------------------------------
co[[5]] <- 5

## -------------------------------------------------------------------------------------------------
co[[3]] <- 0
co[1:2] <- 0
co

## -------------------------------------------------------------------------------------------------
co[list("A", 2, "c")] <- list(1, 2, "three")
co

## -------------------------------------------------------------------------------------------------
co[[{"three"}]] <- 3
co

## -------------------------------------------------------------------------------------------------
co[[{co2}]] <- 3
co

## -------------------------------------------------------------------------------------------------
co[[1]]
co[1:3]

## -------------------------------------------------------------------------------------------------
co[1, 3, "b"]

co[2:1, "A"]

## -------------------------------------------------------------------------------------------------
co[1:100]

## -------------------------------------------------------------------------------------------------
count(co, 1)
count(co, 3)

## -------------------------------------------------------------------------------------------------
sapply(co, is.numeric)

sapply(co, function(x) x + 1)

