% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_utility.R
\name{set_external}
\alias{set_external}
\title{Change Default Graphing Device from RStudio}
\usage{
set_external(ext = TRUE, width = 10, height = 6)
}
\arguments{
\item{ext}{A \code{logical} indicating whether the graph should be done externally or internally in RStudio.}

\item{width}{Width in pixels of the popup window}

\item{height}{Height in pixels of the popup window}
}
\description{
Checks to see if the user is in RStudio. If so, then it changes the device to a popup window.
}
\details{
Depending on the operating system, the default drivers attempted to be used are:

OS X: quartz()

Linux: x11()

Windows: windows()

Note, this setting is not permanent. Thus, the behavioral change will last
until the end of the session.

Also, the active graphing environment will be killed.
As a result, any graphs that are open will be deleted.
}
\examples{
\dontrun{

# Turn on external graphs
external_graphs()

# Turn off external graphs
external_graphs(F)
}

}
