% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demea_change.R
\name{demea_change}
\alias{demea_change}
\title{Calculate changes of deviations from the mean}
\usage{
demea_change(
  myTB,
  timeName = "time",
  time_0 = NA,
  time_t = NA,
  sele_countries = NA,
  doplot = FALSE
)
}
\arguments{
\item{myTB}{a dataset time by countries}

\item{timeName}{name of the variable representing time}

\item{time_0}{starting time}

\item{time_t}{ending time}

\item{sele_countries}{selection of countries to display;
NA means all countries}

\item{doplot}{if a ggplot2 graphical object desired then TRUE, otherwise
it is FALSE}
}
\value{
A list with intermediate and final statistics; list component res_graph
        is a ggplot2 object if the argument doplot = TRUE; to plot the object
        use function plot().
}
\description{
Deviations from the mean of a collection of countries is calculated for
each year. Then differences at subsequent times are calculated within
each member state. Finally negative differences are added over years within
member state, and similarly  positive differences are added over years
within member state.
The output is made by  datasets with intermediate calculations,
and by the component statistics which is  member state by statistics.
}
\details{
Let \deqn{Y_{i,t,m}} be the indicator value i at time t for
country m.
Let \deqn{D_{i,t,m} = Y_{i,t,m} - M_{i,t,m}} be the departure from the mean
        at time t.
Let \deqn{d_{i,t,m} = | D_{i,t,m}| - | D_{i,t,m}|} be the difference of
        absolute values within country m at time t.
Then the overall negative and positive changes   are
   \deqn{Cn(i,t,m) = \sum_{t} d_{i,t,m} I_{d<=0}(d)}
 and
       \deqn{Cp(i,t,m) = \sum_{t} d_{i,t,m} I_{d>0}(d)}
}
\examples{


# Example 1
# A dataset in the format time by countries:
require(tibble)
testTB <- dplyr::tribble(
~time, ~countryA ,  ~countryB,  ~countryC,
2000,     0.8,   2.7,    3.9,
2001,     1.2,   3.2,    4.2,
2002,     0.9,   2.9,    4.1,
2003,     1.3,   2.9,    4.0,
2004,     1.2,   3.1,    4.1,
2005,     1.2,   3.0,    4.0
)
res <- demea_change(testTB,
             timeName="time",
             time_0 = 2000,
             time_t = 2005,
             sele_countries= NA,
             doplot=TRUE)

\donttest{
plot(res$res$res_graph)
}

# Example 2
# Deviations from the mean for the emp_20_64_MS Eurofound dataset
data(emp_20_64_MS)

# Calculate deviations from the mean from 2013 to 2016 for Italy, France and Germany
res1<-demea_change(emp_20_64_MS,
      timeName="time",
      time_0 = 2013,
      time_t = 2016,
      sele_countries= c('IT','FR','DE'),
      doplot=TRUE)
\donttest{
plot(res1$res$res_graph)
}


}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
