% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_dataset.R
\name{ma_dataset}
\alias{ma_dataset}
\title{Smoother based on moving average}
\usage{
ma_dataset(myTB, kappa = 2, timeName = "time")
}
\arguments{
\item{myTB}{a complete dataset (tibble) time by countries, with just
time column and    country columns.}

\item{kappa}{integer greater than 1 as smoothed value, to set the time window of
the moving average.}

\item{timeName}{name of the time variable.}
}
\value{
a dataset  of smoothed values.
}
\description{
The smoother change each value into the average of values around it spanning
a window of size kappa.
Missing values are not allowed.
}
\examples{

# Example 1
# Smoother based on moving average with k=1.5:
require(tibble)

# Dataset in the format time by countries
myTB  <- tibble::tibble(
    time = 2010:2001,
    IT = c(10,14,13,12,9,11,13,17,15,25),
    DE = c(10,11,12,9,14,17,23,29,26,23)
   )
resMA1 <- ma_dataset(myTB, kappa=1.5)

# Smoother based on moving average with k=3:
resMA2<-ma_dataset(myTB, kappa=3)

# Example 2
# Smoother based on moving average for the emp_20_64_MS Eurofound dataset:

myTB1 <-  emp_20_64_MS[,c("time","IT","DE", "FR")]
# Smoother based on moving average with k=2:
resMAeu<-ma_dataset(myTB1, kappa=2, timeName= "time")

# Smoother based on moving average with k=3:
resMAeu1<-ma_dataset(myTB1, kappa=3, timeName= "time")

}
\references{
{\url{https://unimi2013-my.sharepoint.com/:u:/g/personal/federico_stefanini_unimi_it/EW0cVSIgbtZAvLPNbqcxdX8Bfn5VGSRHfAH88hQwc_RIEQ?e=MgtSZu}}
}
