/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.corehunter.CoreHunter;
import org.corehunter.CoreHunterArguments;
import org.corehunter.CoreHunterExecutionMode;
import org.corehunter.CoreHunterMeasure;
import org.corehunter.CoreHunterObjective;
import org.corehunter.CoreHunterObjectiveType;
import org.corehunter.Range;
import org.corehunter.data.CoreHunterData;
import org.corehunter.data.DistanceMatrixData;
import org.corehunter.data.GenotypeData;
import org.corehunter.data.GenotypeDataFormat;
import org.corehunter.data.simple.SimpleBiAllelicGenotypeData;
import org.corehunter.data.simple.SimpleDistanceMatrixData;
import org.corehunter.data.simple.SimpleGenotypeData;
import org.corehunter.data.simple.SimplePhenotypeData;
import org.corehunter.listener.SimpleCoreHunterListener;
import org.jamesframework.core.subset.SubsetSolution;
import uno.informatics.data.Data;
import uno.informatics.data.Feature;
import uno.informatics.data.Scale;
import uno.informatics.data.SimpleEntity;
import uno.informatics.data.io.FileType;
import uno.informatics.data.pojo.DataPojo;
import uno.informatics.data.pojo.SimpleEntityPojo;
import uno.informatics.data.utils.DataOption;

public class API {
    private static final double NA = Double.longBitsToDouble(9218868437227407266L);
    private static final CoreHunterObjectiveType DEFAULT_OBJECTIVE = CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY;
    private static final CoreHunterMeasure DEFAULT_GENOTYPE_MEASURE = CoreHunterMeasure.MODIFIED_ROGERS;

    public static String[] getIds(Data data) {
        int n = data.getSize();
        String[] ids = new String[n];
        for (int i = 0; i < n; ++i) {
            ids[i] = data.getHeader(i).getUniqueIdentifier();
        }
        return ids;
    }

    public static String[] getNames(Data data) {
        int n = data.getSize();
        String[] ids = new String[n];
        for (int i = 0; i < n; ++i) {
            ids[i] = data.getHeader(i).getName();
        }
        return ids;
    }

    public static String[] getIdsFromIndices(Data data, int[] indices) {
        String[] ids = (String[])Arrays.stream(indices).mapToObj(i -> data.getHeader(i).getUniqueIdentifier()).toArray(String[]::new);
        return ids;
    }

    public static int[] getIndicesFromIds(DataPojo data, String[] ids) {
        int[] indices = Arrays.stream(ids).mapToInt(id -> data.indexOf((String)id)).toArray();
        return indices;
    }

    public static DistanceMatrixData readDistanceMatrixData(String file) throws IOException {
        return SimpleDistanceMatrixData.readData(Paths.get(file, new String[0]), API.inferFileType(file));
    }

    public static DistanceMatrixData createDistanceMatrixData(double[][] distances, String[] ids, String[] names) {
        if (distances == null) {
            throw new IllegalArgumentException("Distances are required.");
        }
        int n = distances.length;
        if (ids == null) {
            throw new IllegalArgumentException("Ids are required.");
        }
        if (ids.length != n) {
            throw new IllegalArgumentException("Number of ids does not correspond to size of matrix.");
        }
        if (names != null && names.length != n) {
            throw new IllegalArgumentException("Number of names does not correspond to size of matrix.");
        }
        return new SimpleDistanceMatrixData(API.createHeaders(ids, names), distances);
    }

    public static GenotypeData readGenotypeData(String file, String format) throws IOException {
        return SimpleGenotypeData.readData(Paths.get(file, new String[0]), API.inferFileType(file), GenotypeDataFormat.valueOf(format.toUpperCase()));
    }

    public static GenotypeData createDefaultGenotypeData(String[][] data, String[] ids, String[] names, String[] columnNames) {
        if (data == null) {
            throw new IllegalArgumentException("Data is required.");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("Empty allele matrix.");
        }
        int n = data.length;
        int c = data[0].length;
        if (ids == null) {
            throw new IllegalArgumentException("Ids are required.");
        }
        if (ids.length != n) {
            throw new IllegalArgumentException("Number of ids does not correspond to number of rows.");
        }
        if (names != null && names.length != n) {
            throw new IllegalArgumentException("Number of names does not correspond to number of rows.");
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("Column names are required.");
        }
        if (columnNames.length != c) {
            throw new IllegalArgumentException("Number of column names does not correspond to number of columns.");
        }
        LinkedHashMap<String, Integer> markers = SimpleGenotypeData.inferMarkerNames(columnNames);
        int numMarkers = markers.size();
        String[] markerNames = ((HashMap)markers).keySet().toArray(new String[0]);
        Integer[] markerNumCols = ((HashMap)markers).values().toArray(new Integer[0]);
        String[][][] splitData = new String[n][numMarkers][];
        for (int i = 0; i < n; ++i) {
            if (data[i].length != c) {
                throw new IllegalArgumentException("Incorrect number of values at row " + i + ".");
            }
            int j = 0;
            for (int m = 0; m < numMarkers; ++m) {
                int markerCols = markerNumCols[m];
                splitData[i][m] = new String[markerCols];
                for (int mc = 0; mc < markerCols; ++mc) {
                    splitData[i][m][mc] = data[i][j++];
                }
            }
        }
        return SimpleGenotypeData.createDefaultData(splitData, ids, names, markerNames);
    }

    public static GenotypeData createBiparentalGenotypeData(int[][] alleleScores, String[] ids, String[] names, String[] markerNames) {
        if (alleleScores == null) {
            throw new IllegalArgumentException("Allele scores are required.");
        }
        if (alleleScores.length == 0) {
            throw new IllegalArgumentException("Empty allele score matrix.");
        }
        int n = alleleScores.length;
        int m = alleleScores[0].length;
        if (ids == null) {
            throw new IllegalArgumentException("Ids are required.");
        }
        if (ids.length != n) {
            throw new IllegalArgumentException("Number of ids does not correspond to number of rows.");
        }
        if (names != null && names.length != n) {
            throw new IllegalArgumentException("Number of names does not correspond to number of rows.");
        }
        if (markerNames != null && markerNames.length != m) {
            throw new IllegalArgumentException("Number of marker names does not correspond to number of columns.");
        }
        return new SimpleBiAllelicGenotypeData(API.createHeaders(ids, names), markerNames, API.toIntegerMatrix(alleleScores));
    }

    public static GenotypeData createFrequencyGenotypeData(double[][] frequencies, String[] ids, String[] names, String[] columnNames, String[] alleleNames) {
        int a;
        int markerAlleleCount;
        int m;
        int j;
        if (frequencies == null) {
            throw new IllegalArgumentException("Allele frequencies are required.");
        }
        if (frequencies.length == 0) {
            throw new IllegalArgumentException("Empty allele frequency matrix.");
        }
        int n = frequencies.length;
        int c = frequencies[0].length;
        if (ids == null) {
            throw new IllegalArgumentException("Ids are required.");
        }
        if (ids.length != n) {
            throw new IllegalArgumentException("Number of ids does not correspond to number of rows.");
        }
        if (names != null && names.length != n) {
            throw new IllegalArgumentException("Number of names does not correspond to number of rows.");
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("Column names are required.");
        }
        if (columnNames.length != c) {
            throw new IllegalArgumentException("Number of column names does not correspond to number of columns.");
        }
        if (alleleNames == null) {
            throw new IllegalArgumentException("Allele names are required.");
        }
        if (alleleNames.length != c) {
            throw new IllegalArgumentException("Number of allele names does not correspond to number of columns.");
        }
        LinkedHashMap<String, Integer> markers = SimpleGenotypeData.inferMarkerNames(columnNames);
        int numMarkers = markers.size();
        String[] markerNames = ((HashMap)markers).keySet().toArray(new String[0]);
        Integer[] alleleCounts = ((HashMap)markers).values().toArray(new Integer[0]);
        Double[][][] convFreqs = new Double[n][numMarkers][];
        for (int i = 0; i < n; ++i) {
            if (frequencies[i].length != c) {
                throw new IllegalArgumentException("Incorrect number of values at row " + i + ".");
            }
            j = 0;
            for (m = 0; m < numMarkers; ++m) {
                markerAlleleCount = alleleCounts[m];
                convFreqs[i][m] = new Double[markerAlleleCount];
                for (a = 0; a < markerAlleleCount; ++a) {
                    Double freq;
                    if (Double.isNaN(freq = Double.valueOf(frequencies[i][j++]))) {
                        freq = null;
                    }
                    convFreqs[i][m][a] = freq;
                }
            }
        }
        String[][] convAlleles = new String[numMarkers][];
        j = 0;
        for (m = 0; m < numMarkers; ++m) {
            markerAlleleCount = alleleCounts[m];
            convAlleles[m] = new String[markerAlleleCount];
            for (a = 0; a < markerAlleleCount; ++a) {
                convAlleles[m][a] = alleleNames[j++];
            }
        }
        return new SimpleGenotypeData(API.createHeaders(ids, names), markerNames, convAlleles, convFreqs);
    }

    public static String[][] getAlleles(GenotypeData data) {
        int numMarkers = data.getNumberOfMarkers();
        String[][] alleles = new String[numMarkers][];
        for (int m = 0; m < numMarkers; ++m) {
            int numAlleles = data.getNumberOfAlleles(m);
            alleles[m] = new String[numAlleles];
            for (int a = 0; a < numAlleles; ++a) {
                alleles[m][a] = data.getAlleleName(m, a);
            }
        }
        return alleles;
    }

    public static String[] getMarkerNames(GenotypeData data) {
        int numMarkers = data.getNumberOfMarkers();
        String[] markerNames = new String[numMarkers];
        for (int m = 0; m < numMarkers; ++m) {
            markerNames[m] = data.getMarkerName(m);
        }
        return markerNames;
    }

    public static double[][] getAlleleFrequencies(GenotypeData data) {
        int n = data.getSize();
        int m = data.getNumberOfMarkers();
        int numAlleles = data.getTotalNumberOfAlleles();
        double[][] freqs = new double[n][numAlleles];
        for (int i = 0; i < n; ++i) {
            int a = 0;
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < data.getNumberOfAlleles(j); ++k) {
                    Double freq = data.getAlleleFrequency(i, j, k);
                    freqs[i][a++] = freq == null ? NA : freq;
                }
            }
        }
        return freqs;
    }

    public static SimplePhenotypeData readPhenotypeData(String file) throws IOException {
        return SimplePhenotypeData.readPhenotypeData(Paths.get(file, new String[0]), API.inferFileType(file), new DataOption[0]);
    }

    public static Double[] getRanges(SimplePhenotypeData data) {
        List<Feature> features = data.getFeatures();
        int numTraits = features.size();
        Double[] ranges = new Double[numTraits];
        for (int t = 0; t < numTraits; ++t) {
            Scale scale = features.get(t).getMethod().getScale();
            Number min = scale.getMinimumValue();
            Number max = scale.getMaximumValue();
            if (min == null || max == null) continue;
            ranges[t] = max.doubleValue() - min.doubleValue();
        }
        return ranges;
    }

    public static CoreHunterObjective createObjective(String type, String measure, double weight) {
        return API.createObjective(type, measure, weight, null);
    }

    public static CoreHunterObjective createObjective(String type, String measure, double weight, double min, double max) {
        return API.createObjective(type, measure, weight, new Range<Double>(min, max));
    }

    private static CoreHunterObjective createObjective(String type, String measure, double weight, Range<Double> normalizationRange) {
        return new CoreHunterObjective(CoreHunterObjectiveType.createFromAbbreviation(type), CoreHunterMeasure.createFromAbbreviation(measure), weight, normalizationRange);
    }

    public static CoreHunterArguments createArguments(CoreHunterData data, int size, CoreHunterObjective[] objectives, boolean normalizeMultiObjective) {
        return new CoreHunterArguments(data, size, Arrays.asList(objectives), normalizeMultiObjective);
    }

    public static double[][] getNormalizationRanges(CoreHunterArguments args, String mode, int timeLimit, int maxTimeWithoutImprovement) {
        CoreHunterExecutionMode exMode = CoreHunterExecutionMode.DEFAULT;
        if (mode.equals("fast")) {
            exMode = CoreHunterExecutionMode.FAST;
        }
        CoreHunter ch = new CoreHunter(exMode);
        if (timeLimit > 0) {
            ch.setTimeLimit(1000 * timeLimit);
        }
        if (maxTimeWithoutImprovement > 0) {
            ch.setMaxTimeWithoutImprovement(1000 * maxTimeWithoutImprovement);
        }
        List<Range<Double>> rangeList = ch.normalize(args);
        double[][] ranges = new double[rangeList.size()][2];
        for (int o = 0; o < rangeList.size(); ++o) {
            Range<Double> range = rangeList.get(o);
            ranges[o][0] = range.getLower();
            ranges[o][1] = range.getUpper();
        }
        return ranges;
    }

    public static int[] sampleCore(CoreHunterArguments args, String mode, int timeLimit, int maxTimeWithoutImprovement, boolean silent) {
        CoreHunterExecutionMode exMode = CoreHunterExecutionMode.DEFAULT;
        if (mode.equals("fast")) {
            exMode = CoreHunterExecutionMode.FAST;
        }
        CoreHunter ch = new CoreHunter(exMode);
        if (timeLimit > 0) {
            ch.setTimeLimit(1000 * timeLimit);
        }
        if (maxTimeWithoutImprovement > 0) {
            ch.setMaxTimeWithoutImprovement(1000 * maxTimeWithoutImprovement);
        }
        if (!silent) {
            ch.setListener(new SimpleCoreHunterListener());
        }
        SubsetSolution core = ch.execute(args);
        int[] ids = new int[core.getNumSelectedIDs()];
        int i = 0;
        for (int id : core.getSelectedIDs()) {
            ids[i++] = id;
        }
        return ids;
    }

    public static double evaluateCore(int[] selected, CoreHunterData data, CoreHunterObjective obj) {
        CoreHunter ch = new CoreHunter();
        SubsetSolution sol = new SubsetSolution(data.getIDs());
        for (int sel : selected) {
            sol.select(sel);
        }
        return ch.evaluate(sol, data, obj);
    }

    public static final List<CoreHunterObjective> createDefaultObjectives(CoreHunterData coreHunterData) {
        ArrayList<CoreHunterObjective> objectives = new ArrayList<CoreHunterObjective>();
        if (coreHunterData != null) {
            int count = 0;
            if (coreHunterData.hasGenotypes()) {
                ++count;
            }
            if (coreHunterData.hasPhenotypes()) {
                ++count;
            }
            if (coreHunterData.hasDistances()) {
                ++count;
            }
            if (coreHunterData.hasGenotypes()) {
                objectives.add(new CoreHunterObjective(DEFAULT_OBJECTIVE, DEFAULT_GENOTYPE_MEASURE, 1.0 / (double)count));
            }
            if (coreHunterData.hasPhenotypes()) {
                objectives.add(new CoreHunterObjective(DEFAULT_OBJECTIVE, CoreHunterMeasure.GOWERS, 1.0 / (double)count));
            }
            if (coreHunterData.hasDistances()) {
                objectives.add(new CoreHunterObjective(DEFAULT_OBJECTIVE, CoreHunterMeasure.PRECOMPUTED_DISTANCE, 1.0 / (double)count));
            }
        }
        return objectives;
    }

    public static final CoreHunterObjective createDefaultObjective(CoreHunterData coreHunterData) {
        if (coreHunterData != null) {
            if (coreHunterData.hasGenotypes()) {
                return new CoreHunterObjective(DEFAULT_OBJECTIVE, DEFAULT_GENOTYPE_MEASURE);
            }
            if (coreHunterData.hasPhenotypes()) {
                return new CoreHunterObjective(DEFAULT_OBJECTIVE, CoreHunterMeasure.GOWERS);
            }
            if (coreHunterData.hasDistances()) {
                return new CoreHunterObjective(DEFAULT_OBJECTIVE, CoreHunterMeasure.PRECOMPUTED_DISTANCE);
            }
        }
        return null;
    }

    public static final CoreHunterObjective createDefaultObjective(CoreHunterData coreHunterData, List<CoreHunterObjective> currentObjectives) {
        if (coreHunterData != null) {
            Iterator<CoreHunterObjective> possibleObjectives = API.getAllAllowedObjectives(coreHunterData).iterator();
            boolean found = false;
            CoreHunterObjective objective = null;
            while (!found && possibleObjectives.hasNext()) {
                objective = possibleObjectives.next();
                Iterator<CoreHunterObjective> iterator = currentObjectives.iterator();
                boolean alreadyUsed = false;
                while (!alreadyUsed && iterator.hasNext()) {
                    CoreHunterObjective currentObjective = iterator.next();
                    alreadyUsed = objective.isSameObjective(currentObjective);
                }
                found = !alreadyUsed;
            }
            return objective;
        }
        return null;
    }

    public static final List<CoreHunterObjective> getAllAllowedObjectives(CoreHunterData coreHunterData) {
        ArrayList<CoreHunterObjective> objectives = new ArrayList<CoreHunterObjective>();
        if (coreHunterData != null) {
            if (coreHunterData.hasGenotypes()) {
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY, CoreHunterMeasure.MODIFIED_ROGERS, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY, CoreHunterMeasure.CAVALLI_SFORZA_EDWARDS, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY, CoreHunterMeasure.MODIFIED_ROGERS, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY, CoreHunterMeasure.CAVALLI_SFORZA_EDWARDS, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY, CoreHunterMeasure.MODIFIED_ROGERS, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY, CoreHunterMeasure.CAVALLI_SFORZA_EDWARDS, 1.0));
            }
            if (coreHunterData.hasPhenotypes()) {
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY, CoreHunterMeasure.GOWERS, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY, CoreHunterMeasure.GOWERS, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY, CoreHunterMeasure.GOWERS, 1.0));
            }
            if (coreHunterData.hasDistances()) {
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY, CoreHunterMeasure.PRECOMPUTED_DISTANCE, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY, CoreHunterMeasure.PRECOMPUTED_DISTANCE, 1.0));
                objectives.add(new CoreHunterObjective(CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY, CoreHunterMeasure.PRECOMPUTED_DISTANCE, 1.0));
            }
        }
        return objectives;
    }

    public static final List<CoreHunterObjectiveType> getAllowedObjectiveTypes(CoreHunterData coreHunterData) {
        ArrayList<CoreHunterObjectiveType> objectives = new ArrayList<CoreHunterObjectiveType>();
        if (coreHunterData != null && (coreHunterData.hasPhenotypes() || coreHunterData.hasGenotypes() || coreHunterData.hasDistances())) {
            objectives.add(CoreHunterObjectiveType.AV_ACCESSION_TO_NEAREST_ENTRY);
            objectives.add(CoreHunterObjectiveType.AV_ENTRY_TO_ENTRY);
            objectives.add(CoreHunterObjectiveType.AV_ENTRY_TO_NEAREST_ENTRY);
            if (coreHunterData.hasGenotypes()) {
                objectives.add(CoreHunterObjectiveType.COVERAGE);
                objectives.add(CoreHunterObjectiveType.HETEROZYGOUS_LOCI);
                objectives.add(CoreHunterObjectiveType.SHANNON_DIVERSITY);
            }
        }
        return objectives;
    }

    public static final List<CoreHunterMeasure> getAllowedMeasures(CoreHunterData coreHunterData, CoreHunterObjectiveType objectiveType) {
        return API.getAllowedMeasures(coreHunterData.hasGenotypes(), coreHunterData.hasPhenotypes(), coreHunterData.hasDistances(), objectiveType);
    }

    public static final List<CoreHunterMeasure> getAllowedMeasures(boolean hasGenotypes, boolean hasPhenotypes, boolean hasDistances, CoreHunterObjectiveType objectiveType) {
        ArrayList<CoreHunterMeasure> measures = new ArrayList<CoreHunterMeasure>();
        switch (objectiveType) {
            case AV_ACCESSION_TO_NEAREST_ENTRY: 
            case AV_ENTRY_TO_ENTRY: 
            case AV_ENTRY_TO_NEAREST_ENTRY: {
                if (hasGenotypes) {
                    measures.add(CoreHunterMeasure.MODIFIED_ROGERS);
                    measures.add(CoreHunterMeasure.CAVALLI_SFORZA_EDWARDS);
                }
                if (hasPhenotypes) {
                    measures.add(CoreHunterMeasure.GOWERS);
                }
                if (!hasDistances) break;
                measures.add(CoreHunterMeasure.PRECOMPUTED_DISTANCE);
                break;
            }
        }
        return measures;
    }

    private static FileType inferFileType(String file) {
        if ((file = file.toLowerCase()).endsWith(".txt")) {
            return FileType.TXT;
        }
        if (file.endsWith(".csv")) {
            return FileType.CSV;
        }
        return null;
    }

    private static SimpleEntity[] createHeaders(String[] ids, String[] names) {
        if (names == null) {
            names = ids;
        }
        int n = ids.length;
        SimpleEntity[] headers = new SimpleEntity[n];
        for (int i = 0; i < n; ++i) {
            headers[i] = names[i] != null ? new SimpleEntityPojo(ids[i], names[i]) : new SimpleEntityPojo(ids[i]);
        }
        return headers;
    }

    private static Integer[][] toIntegerMatrix(int[][] matrix) {
        Integer[][] conv = new Integer[matrix.length][];
        for (int i = 0; i < conv.length; ++i) {
            conv[i] = new Integer[matrix[i].length];
            for (int j = 0; j < conv[i].length; ++j) {
                conv[i][j] = matrix[i][j] != Integer.MIN_VALUE ? Integer.valueOf(matrix[i][j]) : null;
            }
        }
        return conv;
    }
}

