% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict.cornet}
\alias{predict.cornet}
\title{Predict binary outcome}
\usage{
\method{predict}{cornet}(object, newx, type = "probability", ...)
}
\arguments{
\item{object}{\link[cornet]{cornet} object}

\item{newx}{covariates\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{type}{\code{"probability"}, \code{"odds"}, \code{"log-odds"}}

\item{...}{further arguments (not applicable)}
}
\description{
Predicts the binary outcome with linear, logistic, and combined regression.
}
\details{
For linear regression, this function tentatively transforms
the predicted values to predicted probabilities,
using a Gaussian distribution with a fixed mean (threshold)
and a fixed variance (estimated variance of the numeric outcome).
}
\examples{
n <- 100; p <- 200
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
net <- cornet(y=y,cutoff=0,X=X)
predict(net,newx=X)

}
