% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsyntax.r
\name{fold_rsyntax}
\alias{fold_rsyntax}
\title{Fold rsyntax annotations}
\usage{
fold_rsyntax(tc, annotation, by_label, ..., txt = F, rm_by = T)
}
\arguments{
\item{tc}{A tCorpus}

\item{annotation}{The name of an rsyntax annotation column}

\item{by_label}{The labels in this column for which you want to aggregate the tokens}

\item{...}{Specify the new aggregated columns in name-value pairs. The name is the name of the new column, and the value should be a function over a column in $tokens. 
For example:  subject = paste(token, collapse = ' ')  would create the column 'subject', of which the values are the concatenated tokens. See examples for more.}

\item{txt}{If TRUE, add _txt column with concatenated tokens for by_label.}

\item{rm_by}{If TRUE (default), remove the column(s) specified in by_label}
}
\value{
a transformed tCorpus
}
\description{
If a tCorpus has rsyntax annotations (see \code{\link{annotate_rsyntax}}), it can be convenient to aggregate tokens that have a certain semantic label.
For example, if you have a query for labeling "source" and "quote", you can add an aggegated value for the sources (such as a unique ID) as a column, and then remove the quote tokens.
}
\examples{
tc = tc_sotu_udpipe$copy()
tc$udpipe_clauses()

fold_rsyntax(tc, 'clause', by_label = 'subject', subject = paste(token, collapse=' '))
}
