% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_smooth.R
\name{cor_smooth}
\alias{cor_smooth}
\alias{is.positive_definite}
\alias{is_positive_definite}
\title{Smooth a non-positive definite correlation matrix to make it positive definite}
\usage{
cor_smooth(x, method = "psych", verbose = TRUE, ...)

is.positive_definite(x, tol = 10^-12, ...)

is_positive_definite(x, tol = 10^-12, ...)
}
\arguments{
\item{x}{A correlation matrix.}

\item{method}{Smoothing method. Can be \code{psych} (will use
\code{psych::cor.smooth()}), \code{hj} (Jorjani et al., 2003) or \code{lrs} (Schaeffer,
2014). For the two last, will use \code{mbend::bend()} (check its documentation
for details).}

\item{verbose}{Set to \code{FALSE} to silence the function.}

\item{...}{Other arguments to be passed to or from other functions.}

\item{tol}{The minimum eigenvalue to be considered as acceptable.}
}
\description{
Make correlations positive definite using \code{psych::cor.smooth}. If smoothing
is done, inferential statistics (\emph{p}-values, confidence intervals, etc.) are
removed, as they are no longer valid.
}
\examples{
set.seed(123)
data <- as.matrix(mtcars)
# Make missing data so pairwise correlation matrix is non-positive definite
data[sample(seq_len(352), size = 60)] <- NA
data <- as.data.frame(data)
x <- correlation(data)
is.positive_definite(x)

smoothed <- cor_smooth(x)
}
