## ----eval = FALSE--------------------------------------------------------
#  install.packages("cosinor")

## ----eval = FALSE--------------------------------------------------------
#  devtools::install_github("cosinor", "sachsmc")

## ------------------------------------------------------------------------
library(cosinor)

## ------------------------------------------------------------------------
fit <- cosinor.lm(Y ~ time(time) + X + amp.acro(X), data = vitamind, period = 12)

## ------------------------------------------------------------------------
summary(fit)

## ------------------------------------------------------------------------
test_cosinor(fit, "X", param = "amp")

## ------------------------------------------------------------------------
summary(vitamind$Y)
summary(predict(fit))

## ------------------------------------------------------------------------
library(ggplot2)
ggplot.cosinor.lm(fit, x_str = "X")

## ----eval = FALSE--------------------------------------------------------
#  cosinor_analyzer(vitamind)

