% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fevdata}
\alias{fevdata}
\title{Forced Expiratory Volume (FEV) Data}
\format{
A data frame with 654 observations on the following 5 variables:
\describe{
\item{\code{AGE}}{Age, in years}
\item{\code{FEV}}{Forced expiratory volume, in liters}
\item{\code{HEIGHT}}{Height, in inches}
\item{\code{SEX}}{\code{0} = Female, \code{1} = Male}
\item{\code{SMOKE}}{\code{0} = Non-smoker, \code{1} = Smoker}
}
}
\usage{
fevdata
}
\description{
Data from: Fundamentals of Biostatistics
Notes from: Kahn, M.
\subsection{Abstract}{

Sample of 654 youths, aged 3 to 19, in the area of East Boston during middle to late 1970's.
Interest concerns the relationship between smoking and FEV. Since the study is necessarily
observational, statistical adjustment via regression models clarifies the relationship.
}

\subsection{Pedagogical Notes:}{

This is a versatile dataset that can be used throughout an introductory statistics course as
well as an introductory modeling course. It includes many issues from statistical adjustment
in observational studies, to subgroup analysis, quadratic regression and analysis of covariance.
}
}
\references{
Kahn,M. (2003). Data Sleuth, STATS, 37, 24. \url{http://jse.amstat.org/datasets/fev.txt}
Rosner, B. (1999). Fundamentals of Biostatistics, Pacific Grove, CA: Duxbury
}
\keyword{datasets}
