% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_r0.R
\name{get_r0}
\alias{get_r0}
\title{Calculate r0}
\usage{
get_r0(
  dat,
  place_var = place,
  daily_var = daily_cases,
  total_var = total_cases,
  daily_filter = 0,
  total_filter = 50,
  min_date = "2020-03-23"
)
}
\arguments{
\item{dat}{Input dataset. Expects \code{daily_cases}, \code{total_cases}, and \code{place} columns}

\item{place_var}{Variable corresponding to the place. If data corresponds to single place, this variable is arbitrary. Default \code{place_var} is \code{place}}

\item{daily_var}{Variable corresponding to the daily (incidence) case count data. Default is \code{daily_cases}}

\item{total_var}{Variable corresponding to the total (cumulative) case count data. Default is \code{total_cases}}

\item{daily_filter}{Threshold for minimum daily cases. Default = \code{0}.}

\item{total_filter}{Threshold for minimum total cases reported to date. Default = \code{50}.}

\item{min_date}{Threshold for earliest date to report R_0. Default = \code{"2020-03-23"}.}
}
\value{
Pulls the time-series state-level testing data directly from covid19india.org. Expects columns named \code{place}, \code{daily_cases}, and \code{total_cases}. Can specify corresponding variables through other arguments.
}
\description{
Calculate r0
}
\examples{
\dontrun{
get_nat_counts() \%>\% get_r0()
}

}
