\name{setLogFileCPLEX}
\alias{setLogFileCPLEX}
\alias{CPXsetlogfile}

\title{
  Modifies the log file to which Messages are Written
}

\description{
  Low level interface function to the IBM ILOG CPLEX function
  \code{CPXsetlogfile}.  Consult the IBM ILOG CPLEX documentation for
  more detailed information.
}

\usage{
  setLogFileCPLEX(env, cpfile = NULL)
}

\arguments{
  \item{env}{
    Pointer to an IBM ILOG CPLEX environment as returned by
    \code{\link{openEnvCPLEX}}.
  }
  \item{cpfile}{
    A pointer to a file as returned by \code{\link{openFileCPLEX}}.
  }
}

\details{
  Interface to the C function \code{getLogFile} which calls the CPLEX
  function \code{CPXgetlogfile}.
}

\value{
  Zero if successful, otherwise nonzero.
}

\references{
  The IBM ILOG CPLEX home page at
  \url{https://www.ibm.com/developerworks/university/academicinitiative/}.
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\seealso{
  \code{\link{getLogFileCPLEX}}
}

\keyword{ optimize }

