% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\docType{methods}
\name{changepoints}
\alias{changepoints}
\alias{changepoints,cpop.class-method}
\title{Changepoint locations}
\arguments{
\item{object}{An instance of an cpop S4 class produced by \code{\link{cpop}}.}
}
\value{
A data frame.
}
\description{
Creates a data frame containing the locations of the changepoints in terms of the index of the data and the value of the location at that index.
}
\examples{
library(cpop)

# generate some test data
set.seed(0)
x <- seq(0,1,0.01)
n <- length(x)
sd <- rep(0.1,n)
mu <- c(2*x[1:floor(n/2)],2 - 2*x[(floor(n/2)+1):n])
y <- rnorm(n,mu,sd)

# use the locations in x
res <- cpop(y,x,beta=2*log(length(y)),sd=sd)
changepoints(res)

}
\references{
\insertRef{cpop-jss-article-2024}{cpop}
}
