% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cpr_cn.R
\name{plot.cpr_cn}
\alias{plot.cpr_cn}
\title{Plotting Control Nets}
\usage{
\method{plot}{cpr_cn}(
  x,
  ...,
  xlab = "",
  ylab = "",
  zlab = "",
  show_net = TRUE,
  show_surface = FALSE,
  get_surface_args,
  net_args,
  surface_args,
  rgl = TRUE
)
}
\arguments{
\item{x}{a \code{cpr_cn} object}

\item{...}{common arguments which would be
used for both the plot of the control net and the surface, e.g., xlim, ylim,
zlim.}

\item{xlab, ylab, zlab}{labels for the axes.}

\item{show_net}{logical, show the control net}

\item{show_surface}{logical, show the tensor product surface}

\item{get_surface_args}{a list of arguments passed to the
\code{\link{get_surface}} call.  This call generates the needed data sets
used in the plotting.}

\item{net_args}{arguments to be used explicitly for the control net.  Ignored
if \code{show_net = FALSE}.}

\item{surface_args}{arguments to be used explicitly for the surface.  Ignored
if \code{show_surface = FALSE}.}

\item{rgl}{If \code{TRUE}, the default, generate use \code{rgl::persp3d} to
generate the graphics.  If \code{FALSE}, use \code{plot3D::persp3D} to
generate the graphics.}
}
\value{
The result of the \code{get_surface} call is returned invisibly.
}
\description{
Three-dimensional plots of control nets and/or surfaces
}
\details{
This plotting method generates three-dimensional plots of the control net,
surface, or both, for a \code{cpr_cn} objects.  The three-dimensional plots
are generated by either \code{\link[plot3D]{persp3D}} form the \code{plot3D}
package or \code{\link[rgl]{persp3d}} from the \code{rgl} package.
\code{rgl} graphics may or may not work on your system depending on support
for OpenGL.

Building complex and customized graphics might be easier for you if you use
\code{\link{get_surface}} to generate the needed data for plotting.  See
\code{vignette("cpr-pkg", package = "cpr")} for examples of building
different plots.

For \code{rgl} graphics, the \code{surface_args} and \code{net_args} are
lists of \code{\link[rgl]{rgl.material}} and other arguments passed to
\code{\link[rgl]{persp3d}}. Defaults are \code{col = "black", front =
"lines", back = "lines"} for the \code{net_args} and
\code{col = "grey20", front = "fill", back = "lines"} for the
\code{surface_args}.

For \code{plot3D} graphics there are no defaults values for the
\code{net_args} and \code{surface_args}.
}
\examples{
## see vignette("cpr-pkg", package = "cpr")

}
\seealso{
\code{\link{plot.cpr_cp}} for plotting control polygons and splines,
\code{\link[rgl]{persp3d}} and \code{\link[rgl]{rgl.material}} for generating
and controlling rgl graphics. \code{\link[plot3D]{persp3D}} for building
plot3D graphics. \code{\link{get_surface}} for generating the data sets
needed for the plotting methods.
}
