% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argosDiag2Cov.R
\name{argosDiag2Cov}
\alias{argosDiag2Cov}
\title{Tranform Argos diagnostic data to covariance matrix form}
\usage{
argosDiag2Cov(Major, Minor, Orientation)
}
\arguments{
\item{Major}{A vector containing the major axis information for each observation}

\item{Minor}{A vector containing the minor axis information for each observation}

\item{Orientation}{A vector containing the angle orientation of the Major axis from North}
}
\value{
A \code{data.frame} with the following columns
\item{ln.sd.x}{The log standard deviation of the location error in the x coordinate}
\item{ln.sd.y}{The log standard deviation of the location error in the x coordinate}
\item{rho}{The correlation of the bivariate location error ellipse}
}
\description{
Using this function the user can transform the Argos diagnostic data for location
error into a form usable as a covariance matrix to approximate the location error with a
bivariate Gaussian distribution. The resulting data.frame should be attached back to the data
with \code{cbind} to use with the \code{crwMLE} function.
}
\author{
Devin S. Johnson
}

