% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{lme_permute2}
\alias{lme_permute2}
\title{Generate a new permutation}
\usage{
lme_permute2(
  fitlist,
  data,
  null_par = rep(0, length(fitlist)),
  cl_var = "cl",
  rand_func = NULL
)
}
\arguments{
\item{fitlist}{A list of glm model objects fitted under the null hypotheses}

\item{data}{A data frame containing the data used to fit the models in fitlist}

\item{null_par}{A vector of the same length as fitlist specifying the value(s) of the
treatment effect parameter(s) under the null hypotheses}

\item{cl_var}{String specifying the name of the column identifying the clusters/cluster-time}

\item{rand_func}{String of the name of a function that re-randomises the clusters. The function should
produce a data frame that identifies the clusters in the treatment group under the new
randomisation scheme. The data frame can either have a single column with name cl_var or
two columns of cl_var and t identifying the cluster ID and time period a cluster joins
the treatment group. If NULL then clusters are randomised in a 1:1 ratio to treatment and control}
}
\value{
A vector of the length of fitlist with the test statistics for each model and null
hypothesis
}
\description{
Returns the test statistic from a specified null hypothesis and model under a single new
permutation
}
\examples{
out <- twoarm_sim()
data <- out[[1]]
  fit1 <- lme4::glmer(y1 ~ treat + (1|cl) ,
data=data,
family="poisson")

fit2 <- lme4::glmer(y2 ~ treat + (1|cl),
                    data=data,
                    family="poisson")
fitlist <- list(fit1,fit2)
nullfitlist <- list()
for(i in 1:length(fitlist)){
  nullfitlist[[i]] <- est_null_model(fitlist[[i]],
                                     data,
                                     tr_var = "treat",
                                     null_par = 0)
}
out <- lme_permute2(nullfitlist,
               data=data,
               cl_var = "cl")
}
