% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Design-methods.R
\docType{methods}
\name{simulate,RuleDesign-method}
\alias{simulate,RuleDesign-method}
\title{Simulate outcomes from a rule-based design}
\usage{
\S4method{simulate}{RuleDesign}(object, nsim = 1L, seed = NULL, truth,
  args = NULL, parallel = FALSE, ...)
}
\arguments{
\item{object}{the \code{\linkS4class{RuleDesign}} object we want to simulate
data from}

\item{nsim}{the number of simulations (default: 1)}

\item{seed}{see \code{\link{setSeed}}}

\item{truth}{a function which takes as input a dose (vector) and returns the
true probability (vector) for toxicity. Additional arguments can be supplied
in \code{args}.}

\item{args}{data frame with arguments for the \code{truth} function. The
column names correspond to the argument names, the rows to the values of the
arguments. The rows are appropriately recycled in the \code{nsim}
simulations.}

\item{parallel}{should the simulation runs be parallelized across the
clusters of the computer? (not default)}

\item{\dots}{not used}
}
\value{
an object of class \code{\linkS4class{GeneralSimulations}}
}
\description{
Simulate outcomes from a rule-based design
}
\examples{

# Define the dose-grid
emptydata <- Data(doseGrid = c(5, 10, 15, 25, 35, 50, 80))

# inizialing a 3+3 design with constant cohort size of 3 and
# starting dose equal 5
myDesign <- RuleDesign(nextBest = NextBestThreePlusThree(),
                       cohortSize = CohortSizeConst(size=3L),
                       data = emptydata,
                       startingDose = 5)

model <- LogisticLogNormal(mean = c(-0.85, 1),
                           cov = matrix(c(1, -0.5, -0.5, 1), nrow = 2),
                           refDose = 50)
  
## define the true function
myTruth <- function(dose)
{
  model@prob(dose, alpha0=7, alpha1=8)
}

# Perform the simulation
##For illustration purpose only 10 simulation is produced (nsim=10). 
threeSims <- simulate(myDesign,
                      nsim=10,
                      seed=35,
                      truth=myTruth,
                      parallel=FALSE)
}
\keyword{methods}

