% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.crossnma.model.R
\name{summary.crossnma.model}
\alias{summary.crossnma.model}
\title{Summary function for crossnma.model object}
\usage{
\method{summary}{crossnma.model}(object, ...)
}
\arguments{
\item{object}{An object generated by the
\code{\link{crossnma.model}}.}

\item{\dots}{Additional arguments (ignored)}
}
\description{
Summary function for crossnma.model object
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
stddata # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

summary(mod)

}
\seealso{
\code{\link{print.summary.crossnma.model}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
