% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{verb-POST}
\alias{verb-POST}
\title{HTTP verb info: POST}
\description{
The POST method is used to submit an entity to the specified resource,
often causing a change in state or side effects on the server.
}
\section{The POST method}{

If one or more resources has been created on the origin server as a
result of successfully processing a POST request, the origin server
SHOULD send a 201 (Created) response containing a Location header
field that provides an identifier for the primary resource created
(Section 7.1.2 \url{https://tools.ietf.org/html/rfc7231#section-7.1.2})
and a representation that describes the status of the
request while referring to the new resource(s).

See \url{https://tools.ietf.org/html/rfc7231#section-4.3.3} for further
details.
}

\examples{
\dontrun{
x <- HttpClient$new(url = "https://httpbin.org")
x$post(path = 'post', body = list(hello = "world"))
}

}
\references{
\url{https://tools.ietf.org/html/rfc7231#section-4.3.3}
}
\seealso{
\link{crul-package}

Other verbs: \code{\link{verb-DELETE}},
  \code{\link{verb-GET}}, \code{\link{verb-HEAD}},
  \code{\link{verb-PATCH}}, \code{\link{verb-PUT}}
}
\concept{verbs}
