% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{settings}
\alias{settings}
\alias{settings<-}
\title{View and modify dataset-level settings}
\usage{
settings(x)

settings(x) <- value
}
\arguments{
\item{x}{CrunchDataset}

\item{value}{A settings object (\code{ShojiEntity}), for the setter}
}
\value{
The getter returns a settings object (\code{ShojiEntity}). The setter
returns the dataset (\code{x}).
}
\description{
These methods allow access and control over dataset settings. Currently
supported settings include 'viewers_can_export' and
'viewers_can_change_weight', which govern specific authorizations for users
with view-only access to this datset; and 'weight', which is the default
weight variable for the dataset, the one that will be set for newly shared
users and the one that viewers will have always on if they are not authorized
to change weights. Additional settings will be added in the future. See
\url{http://docs.crunch.io/#fragments}, under 'Settings', for an up-to-date
list of settings supported throughout the Crunch system. Clients may also
provide and use custom settings if they choose.
}
\examples{
\dontrun{
settings(ds)
settings(ds)$viewers_can_export <- TRUE
}
}

