% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable-delete.R
\name{deleteSubvariables}
\alias{deleteSubvariables}
\alias{deleteSubvariable}
\title{Delete subvariables from an array}
\usage{
deleteSubvariables(variable, to.delete, confirm = requireConsent())

deleteSubvariable(variable, to.delete, confirm = requireConsent())
}
\arguments{
\item{variable}{the array variable}

\item{to.delete}{aliases (following \code{crunch.namekey.dataset}) or indices
of variables to delete.}

\item{confirm}{logical: should the user be asked to confirm deletion.
Default is \code{TRUE} if in
an interactive session. You can avoid the confirmation prompt if you delete
\code{with(\link{consent})}.}
}
\value{
a new version of variable without the indicated subvariables
}
\description{
This function conceals the dirty work in making this happen. The array
gets unbound, the subvariables deleted, and then the remaining subvariable
are rebound into a new array.
}
