% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/abstract-categories.R,
%   R/categories.R
\docType{class}
\name{Categories-class}
\alias{Categories-class}
\alias{Categories}
\alias{ids}
\alias{ids<-}
\alias{values}
\alias{values<-}
\alias{id.AbstractCategory}
\alias{ids.AbstractCategories}
\alias{Category-class}
\alias{Category}
\alias{[,AbstractCategories,ANY,ANY-method}
\alias{[,AbstractCategories,character,ANY-method}
\alias{[,AbstractCategories,numeric,ANY-method}
\alias{[<-,AbstractCategories,character,ANY,ANY-method}
\alias{[[,AbstractCategories,character-method}
\alias{[[<-,AbstractCategories,character,ANY,ANY-method}
\alias{names,AbstractCategories-method}
\alias{names<-,AbstractCategories-method}
\alias{ids,AbstractCategories-method}
\alias{[<-,Categories,ANY,ANY,ANY-method}
\alias{ids<-,Categories-method}
\alias{values,Categories-method}
\alias{values<-,Categories-method}
\title{Categories in CategoricalVariables}
\usage{
Categories(..., data = NULL)

Category(..., data = NULL)

\S4method{[}{AbstractCategories,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{AbstractCategories,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{AbstractCategories,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{AbstractCategories,character,ANY,ANY}(x, i, j, ...) <- value

\S4method{[[}{AbstractCategories,character}(x, i, j, ...)

\S4method{[[}{AbstractCategories,character,ANY,ANY}(x, i, j,
  ...) <- value

\S4method{names}{AbstractCategories}(x)

\S4method{names}{AbstractCategories}(x) <- value

\S4method{ids}{AbstractCategories}(x)

\S4method{[}{Categories,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{ids}{Categories}(x) <- value

\S4method{values}{Categories}(x)

\S4method{values}{Categories}(x) <- value
}
\arguments{
\item{...}{additional arguments to \code{[}, ignored}

\item{data}{For the constructor functions \code{Category} and
\code{Categories}, you can either pass in attributes via \code{...} or you
can create the objects with a fully defined \code{list} representation of
the objects via the \code{data} argument. See the examples.}

\item{x}{For the attribute getters and setters, an object of class
Category or Categories}

\item{i}{For the \code{[} methods, just as with list extract methods}

\item{j}{Invalid argument to \code{[}, but in the generic's signature}

\item{drop}{Invalid argument to \code{[}, but in the generic's signature}

\item{value}{For \code{[<-}, the replacement Category to insert}
}
\description{
CategoricalVariables, as well as the array types composed from
Categoricals, contain Categories. Categories are a subclass of list that
contains only Category objects. Category objects are themselves subclasses of
lists and contain the following fields: "name", "id", "numeric_value",
"missing", and optionally "selected".
}
\examples{
cat.a <- Category(name="First", id=1, numeric_value=1, missing=FALSE)
cat.b <- Category(data=list(name="First", id=1, numeric_value=1, missing=FALSE))
identical(cat.a, cat.b)
cat.c <- Category(name="Second", id=2)
cats.1 <- Categories(cat.a, cat.c)
cats.2 <- Categories(data=list(cat.a, cat.c))
identical(cats.1, cats.2)
}
