% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{crunch-uni}
\alias{crunch-uni}
\alias{mean}
\alias{sd}
\alias{median}
\alias{min}
\alias{max}
\alias{mean,CrunchVariable-method}
\alias{mean,NumericVariable-method}
\alias{sd,CrunchVariable-method}
\alias{sd,NumericVariable-method}
\alias{min,CrunchVariable-method}
\alias{min,NumericVariable-method}
\alias{min,DatetimeVariable-method}
\alias{max,CrunchVariable-method}
\alias{max,NumericVariable-method}
\alias{max,DatetimeVariable-method}
\title{Univariate statistics on Crunch objects}
\usage{
mean(x, ...)

sd(x, na.rm = FALSE)

median(x, na.rm = FALSE, ...)

\S4method{mean}{CrunchVariable}(x, ...)

\S4method{mean}{NumericVariable}(x, ...)

\S4method{sd}{CrunchVariable}(x, na.rm = FALSE)

\S4method{sd}{NumericVariable}(x, na.rm = FALSE)

\S4method{min}{CrunchVariable}(x, na.rm)

\S4method{min}{NumericVariable}(x, na.rm = FALSE)

\S4method{min}{DatetimeVariable}(x, na.rm = FALSE)

\S4method{max}{CrunchVariable}(x, na.rm)

\S4method{max}{NumericVariable}(x, na.rm = FALSE)

\S4method{max}{DatetimeVariable}(x, na.rm = FALSE)
}
\arguments{
\item{x}{a NumericVariable, or for \code{min} and \code{max}, a NumericVariable or
DatetimeVariable}

\item{...}{additional arguments to summary statistic function}

\item{na.rm}{logical: exclude missings?}
}
\description{
Univariate statistics on Crunch objects
}
\seealso{
\code{\link[base:mean]{base::mean()}} \code{\link[stats:sd]{stats::sd()}} \code{\link[stats:median]{stats::median()}} \code{\link[base:Extremes]{base::min()}}
\code{\link[base:Extremes]{base::max()}}
}
