/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.geotools.dbffile.DbfFile;
import org.geotools.shapefile.Shapefile;

public class ShapefileReader
implements JUMPReader {
    private File delete_this_tmp_dbf = null;
    public static final String FILE_PROPERTY_KEY = "File";
    public static final String DEFAULT_VALUE_PROPERTY_KEY = "DefaultValue";
    public static final String COMPRESSED_FILE_PROPERTY_KEY = "CompressedFile";

    public FeatureCollection read(DriverProperties dp) throws IllegalParametersException, Exception {
        String shpfileName = dp.getProperty(FILE_PROPERTY_KEY);
        if (shpfileName == null) {
            shpfileName = dp.getProperty(DEFAULT_VALUE_PROPERTY_KEY);
        }
        if (shpfileName == null) {
            throw new IllegalParametersException("no File property specified");
        }
        int loc = shpfileName.lastIndexOf(File.separatorChar);
        String path = shpfileName.substring(0, loc + 1);
        String fname = shpfileName.substring(loc + 1);
        if ((loc = fname.lastIndexOf(".")) == -1) {
            throw new IllegalParametersException("Filename must end in '.shp'");
        }
        String fnameWithoutExtention = fname.substring(0, loc);
        String dbfFileName = path + fnameWithoutExtention + ".dbf";
        Shapefile myshape = this.getShapefile(shpfileName, dp.getProperty(COMPRESSED_FILE_PROPERTY_KEY));
        DbfFile mydbf = this.getDbfFile(dbfFileName, dp.getProperty(COMPRESSED_FILE_PROPERTY_KEY));
        GeometryFactory factory = new GeometryFactory();
        GeometryCollection collection = myshape.read(factory);
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset featureCollection = null;
        if (mydbf == null) {
            featureCollection = new FeatureDataset(fs);
            int numGeometries = collection.getNumGeometries();
            for (int x = 0; x < numGeometries; ++x) {
                BasicFeature feature = new BasicFeature(fs);
                Geometry geo = collection.getGeometryN(x);
                feature.setGeometry(geo);
                featureCollection.add(feature);
            }
        } else {
            int numfields = mydbf.getNumFields();
            for (int j = 0; j < numfields; ++j) {
                AttributeType type = AttributeType.toAttributeType(mydbf.getFieldType(j));
                fs.addAttribute(mydbf.getFieldName(j), type);
            }
            featureCollection = new FeatureDataset(fs);
            for (int x = 0; x < mydbf.getLastRec(); ++x) {
                BasicFeature feature = new BasicFeature(fs);
                Geometry geo = collection.getGeometryN(x);
                StringBuffer s = mydbf.GetDbfRec(x);
                for (int y = 0; y < numfields; ++y) {
                    feature.setAttribute(y + 1, mydbf.ParseRecordColumn(s, y));
                }
                feature.setGeometry(geo);
                featureCollection.add(feature);
            }
            mydbf.close();
            this.deleteTmpDbf();
        }
        System.gc();
        return featureCollection;
    }

    protected Shapefile getShapefile(String shpfileName, String compressedFname) throws Exception {
        InputStream in = CompressedFile.openFile(shpfileName, compressedFname);
        Shapefile myshape = new Shapefile(in);
        return myshape;
    }

    protected DbfFile getDbfFile(String dbfFileName, String compressedFname) throws Exception {
        DbfFile mydbf = null;
        if (compressedFname != null && compressedFname.length() > 0) {
            byte[] b = new byte[16000];
            boolean keepGoing = true;
            File file = File.createTempFile("dbf", ".dbf");
            FileOutputStream out = new FileOutputStream(file);
            InputStream in = CompressedFile.openFile(dbfFileName, compressedFname);
            while (keepGoing) {
                int len = in.read(b);
                if (len > 0) {
                    out.write(b, 0, len);
                }
                keepGoing = len != -1;
            }
            in.close();
            out.close();
            mydbf = new DbfFile(file.toString());
            this.delete_this_tmp_dbf = file;
        } else {
            File dbfFile = new File(dbfFileName);
            if (dbfFile.exists()) {
                mydbf = new DbfFile(dbfFileName);
            }
        }
        return mydbf;
    }

    private void deleteTmpDbf() {
        if (this.delete_this_tmp_dbf != null) {
            this.delete_this_tmp_dbf.delete();
            this.delete_this_tmp_dbf = null;
        }
    }
}

