/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.buffer.RightmostEdgeFinder;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class BufferSubgraph
implements Comparable {
    private RightmostEdgeFinder finder;
    private List dirEdgeList = new ArrayList();
    private List nodes = new ArrayList();
    private Coordinate rightMostCoord = null;
    private Envelope env = null;

    public BufferSubgraph(CGAlgorithms cga) {
        this.finder = new RightmostEdgeFinder(cga);
    }

    public List getDirectedEdges() {
        return this.dirEdgeList;
    }

    public List getNodes() {
        return this.nodes;
    }

    public Envelope getEnvelope() {
        if (this.env == null) {
            Envelope edgeEnv = new Envelope();
            Iterator it = this.dirEdgeList.iterator();
            while (it.hasNext()) {
                DirectedEdge dirEdge = (DirectedEdge)it.next();
                Coordinate[] pts = dirEdge.getEdge().getCoordinates();
                for (int i = 0; i < pts.length - 1; ++i) {
                    edgeEnv.expandToInclude(pts[i]);
                }
            }
            this.env = edgeEnv;
        }
        return this.env;
    }

    public Coordinate getRightmostCoordinate() {
        return this.rightMostCoord;
    }

    public void create(Node node) {
        this.addReachable(node);
        this.finder.findEdge(this.dirEdgeList);
        this.rightMostCoord = this.finder.getCoordinate();
    }

    private void addReachable(Node startNode) {
        Stack<Node> nodeStack = new Stack<Node>();
        nodeStack.add(startNode);
        while (!nodeStack.empty()) {
            Node node = (Node)nodeStack.pop();
            this.add(node, nodeStack);
        }
    }

    private void add(Node node, Stack nodeStack) {
        node.setVisited(true);
        this.nodes.add(node);
        Iterator i = ((DirectedEdgeStar)node.getEdges()).iterator();
        while (i.hasNext()) {
            DirectedEdge de = (DirectedEdge)i.next();
            this.dirEdgeList.add(de);
            DirectedEdge sym = de.getSym();
            Node symNode = sym.getNode();
            if (symNode.isVisited()) continue;
            nodeStack.push(symNode);
        }
    }

    private void clearVisitedEdges() {
        Iterator it = this.dirEdgeList.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            de.setVisited(false);
        }
    }

    public void computeDepth(int outsideDepth) {
        this.clearVisitedEdges();
        DirectedEdge de = this.finder.getEdge();
        Node n = de.getNode();
        Label label = de.getLabel();
        de.setEdgeDepths(2, outsideDepth);
        this.copySymDepths(de);
        this.computeDepths(de);
    }

    private void computeDepths(DirectedEdge startEdge) {
        HashSet<Node> nodesVisited = new HashSet<Node>();
        LinkedList<Node> nodeQueue = new LinkedList<Node>();
        Node startNode = startEdge.getNode();
        nodeQueue.addLast(startNode);
        nodesVisited.add(startNode);
        startEdge.setVisited(true);
        while (!nodeQueue.isEmpty()) {
            Node n = (Node)nodeQueue.removeFirst();
            nodesVisited.add(n);
            this.computeNodeDepth(n);
            Iterator i = ((DirectedEdgeStar)n.getEdges()).iterator();
            while (i.hasNext()) {
                Node adjNode;
                DirectedEdge de = (DirectedEdge)i.next();
                DirectedEdge sym = de.getSym();
                if (sym.isVisited() || nodesVisited.contains(adjNode = sym.getNode())) continue;
                nodeQueue.addLast(adjNode);
                nodesVisited.add(adjNode);
            }
        }
    }

    private void computeNodeDepth(Node n) {
        DirectedEdge de;
        DirectedEdge startEdge = null;
        Iterator i = ((DirectedEdgeStar)n.getEdges()).iterator();
        while (i.hasNext()) {
            de = (DirectedEdge)i.next();
            if (!de.isVisited() && !de.getSym().isVisited()) continue;
            startEdge = de;
            break;
        }
        Assert.isTrue(startEdge != null, "unable to find edge to compute depths at " + n.getCoordinate());
        ((DirectedEdgeStar)n.getEdges()).computeDepths(startEdge);
        i = ((DirectedEdgeStar)n.getEdges()).iterator();
        while (i.hasNext()) {
            de = (DirectedEdge)i.next();
            de.setVisited(true);
            this.copySymDepths(de);
        }
    }

    private void copySymDepths(DirectedEdge de) {
        DirectedEdge sym = de.getSym();
        sym.setDepth(1, de.getDepth(2));
        sym.setDepth(2, de.getDepth(1));
    }

    public void findResultEdges() {
        Iterator it = this.dirEdgeList.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (de.getDepth(2) < 1 || de.getDepth(1) > 0 || de.isInteriorAreaEdge()) continue;
            de.setInResult(true);
        }
    }

    public int compareTo(Object o) {
        BufferSubgraph graph = (BufferSubgraph)o;
        if (this.rightMostCoord.x < graph.rightMostCoord.x) {
            return -1;
        }
        if (this.rightMostCoord.x > graph.rightMostCoord.x) {
            return 1;
        }
        return 0;
    }
}

