% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LASSO2_predict.R
\name{LASSO2_predict}
\alias{LASSO2_predict}
\title{Predict and Validate LASSO2 Model Scores}
\usage{
LASSO2_predict(
  lassoObj,
  newdata = NULL,
  newY = FALSE,
  u = 2,
  outfile = "nameWithPath"
)
}
\arguments{
\item{lassoObj}{A LASSO2 object.}

\item{newdata}{A new data matrix or data frame where samples are in rows and features/traits are in columns.}

\item{newY}{The outcome variable for the new data set.}

\item{u}{A single numeric follow-up time for survival outcomes.}

\item{outfile}{A string for the output file including the path, if necessary, but without the file type extension.}
}
\value{
A vector of predicted values is returned.
}
\description{
This function predicts model scores, positive group probabilities, and risk scores for different outcome types based on a LASSO2 object and a new data set.
It also performs validation of predictions when the true outcome variable is available.
}
\examples{
# Load in data sets:
data("datlist", package = "csmpv")
tdat = datlist$training
vdat = datlist$validation

# The function saves files locally. You can define your own temporary directory. 
# If not, tempdir() can be used to get the system's temporary directory.
temp_dir = tempdir()
# As an example, let's define Xvars, which will be used later:
Xvars = c("highIPI", "B.Symptoms", "MYC.IHC", "BCL2.IHC", "CD10.IHC", "BCL6.IHC")
# The function can work with three different outcome types. 
# Here, we use time-to-event as an example:
# tl = LASSO2(data = tdat, biomks = Xvars,
#             outcomeType = "time-to-event",
#             time = "FFP..Years.",event = "Code.FFP",
#             outfile = paste0(temp_dir, "/survivalLASSO2"))
# To predict the model in a new data set:
# ptl = LASSO2_predict(tl, newdata = vdat,
#                     outfile = paste0(temp_dir, "/pred_LASSO2_time_to_event"))
# You might save the files to the directory you want.

# To delete the temp_dir, use the following:
unlink(temp_dir)
}
\references{
Friedman, J., Hastie, T. and Tibshirani, R. (2008) Regularization Paths for Generalized Linear Models via Coordinate Descent (2010), Journal of Statistical Software, Vol. 33(1), 1-22, doi:10.18637/jss.v033.i01.
  Simon, N., Friedman, J., Hastie, T. and Tibshirani, R. (2011) Regularization Paths for Cox's Proportional Hazards Model via Coordinate Descent, Journal of Statistical Software, Vol. 39(5), 1-13, doi:10.18637/jss.v039.i05.
  Harrell Jr F (2023). rms: Regression Modeling Strategies_. R package version 6.7-1, <https://CRAN.R-project.org/package=rms>
  Harrell Jr F (2023). Hmisc: Harrell Miscellaneous_. R package version 5.1-1, <https://CRAN.R-project.org/package=Hmisc>
}
\author{
Aixiang Jiang
}
