% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cso_get_meta.R
\name{cso_get_vars}
\alias{cso_get_vars}
\title{Returns a character vector listing the contents of a CSO data table}
\usage{
cso_get_vars(table_code, cache_data = TRUE)
}
\arguments{
\item{table_code}{string. A valid code for one table from the
StatBank.}

\item{cache_data}{logical. Whether to use cached data, if available.
Default value is TRUE. Strongly recommended to use caching, as otherwise
the entire table could be downloaded only to access a small part of its
metadata.}
}
\value{
character vector. The names of the statistics included in the
table, with one element for each statistic.
}
\description{
Reads the metadata of a table to return a character vector of the
included variables in the table.
}
\examples{
cso_get_vars("IPA03")
}
