% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbFindIdsUniqueTrials}
\alias{dbFindIdsUniqueTrials}
\title{Get identifiers of deduplicated trial records}
\usage{
dbFindIdsUniqueTrials(
  preferregister = c("EUCTR", "CTGOV", "ISRCTN", "CTIS"),
  prefermemberstate = "DE",
  include3rdcountrytrials = TRUE,
  con,
  verbose = FALSE
)
}
\arguments{
\item{preferregister}{A vector of the order of preference for
registers from which to generate unique _id's, default
\code{c("EUCTR", "CTGOV", "ISRCTN", "CTIS")}}

\item{prefermemberstate}{Code of single EU Member State for which records
should returned. If not available, a record for DE or lacking this, any
random Member State's record for the trial will be returned.
For a list of codes of EU  Member States, please see vector
\code{countriesEUCTR}. Specifying "3RD" will return the Third Country
record of trials, where available.}

\item{include3rdcountrytrials}{A logical value if trials should be retained
that are conducted exclusively in third countries, that is, outside
the European Union. Ignored if \code{prefermemberstate} is set to "3RD".}

\item{con}{A connection object, see section
`Databases` in \link{ctrdata-package}.}

\item{verbose}{If set to \code{TRUE}, prints out which fields
of the registers are used to find corresponding trial records}
}
\value{
A named vector with strings of keys (field "_id") of
records in the collection that represent unique trials, where
names correspond to the register of the record.
}
\description{
Records for a clinical trial can be loaded from more than one
register into a collection. This function returns deduplicated
identifiers for all trials in the collection, respecting the
register(s) preferred by the user. All registers are recording
identifiers also from other registers, which are used by this
function to provide a vector of identifiers of deduplicated trials.
}
\details{
Note that the content of records may differ between registers
(and, for "EUCTR", between records for different Member States).
Such differences are not considered by this function.
}
\examples{

dbc <- nodbi::src_sqlite(
   dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
   collection = "my_trials")

dbFindIdsUniqueTrials(con = dbc)

}
