% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ctrOpenSearchPagesInBrowser}
\alias{ctrOpenSearchPagesInBrowser}
\title{Open stored query or register search page}
\usage{
ctrOpenSearchPagesInBrowser(url = "", register = "", copyright = FALSE, ...)
}
\arguments{
\item{url}{of search results page to show in the browser.
Can be the return value of \link{ctrGetQueryUrl} or \link{dbQueryHistory}.}

\item{register}{Register(s) to open. Either "EUCTR" or "CTGOV" or a vector of
both. Default is to open both registers' advanced search pages. To open the
browser with a previous search, the output of \link{ctrGetQueryUrl}
or one row from \link{dbQueryHistory} can be used.}

\item{copyright}{(Optional) If set to \code{TRUE}, opens copyright pages of
register(s).}

\item{...}{May include the deprecated \code{input} parameter.}
}
\value{
Always \code{TRUE}, invisibly.
}
\description{
Open advanced search pages of register(s), or execute search in browser
}
\examples{
\dontrun{

# Check copyrights before using registers
ctrOpenSearchPagesInBrowser(copyright = TRUE)

# open last query loaded into the collection
dbc <- nodbi::src_sqlite(
  collection = "previously_created"
)
ctrOpenSearchPagesInBrowser(
  dbQueryHistory(con = dbc))

}
}
