% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctKalman.R
\name{ctKalman}
\alias{ctKalman}
\title{ctKalman}
\usage{
ctKalman(
  fit,
  timerange = "asdata",
  timestep = "auto",
  subjects = 1,
  removeObs = FALSE,
  plot = FALSE,
  realid = FALSE,
  ...
)
}
\arguments{
\item{fit}{fit object as generated by \code{\link{ctStanFit}}.}

\item{timerange}{Either 'asdata' to just use the observed data range, or a numeric vector of length 2 denoting start and end of time range, 
allowing for estimates outside the range of observed data. Ranges smaller than the observed data
are ignored.}

\item{timestep}{Either 'asdata' to just use the observed data 
(which also requires 'asdata' for timerange) or a positive numeric value
indicating the time step to use for interpolating values. Lower values give a more accurate / smooth representation,
but take a little more time to calculate. Currently unavailable for ctStan fits.}

\item{subjects}{vector of integers denoting which subjects (from 1 to N) to plot predictions for.}

\item{removeObs}{Logical. If TRUE, observations (but not covariates)
are set to NA, so only expectations based on
parameters and covariates are returned.}

\item{plot}{Logical. If TRUE, plots output instead of returning it. 
See \code{\link{plot.ctKalmanDF}} 
(Stan based fit) for the possible arguments.}

\item{realid}{Output using original (not necessarily integer sequence) subject id's?}

\item{...}{additional arguments to pass to \code{\link{plot.ctKalmanDF}}.}
}
\value{
Returns a list containing matrix objects etaprior, etaupd, etasmooth, y, yprior, 
yupd, ysmooth, prederror, time, loglik,  with values for each time point in each row. 
eta refers to latent states and y to manifest indicators - y itself is thus just 
the input data. 
Covariance matrices etapriorcov, etaupdcov, etasmoothcov, ypriorcov, yupdcov, ysmoothcov,  
are returned in a row * column * time array. 
Some outputs are unavailable for ctStan fits at present.
If plot=TRUE, nothing is returned but a plot is generated.
}
\description{
Outputs predicted, updated, and smoothed estimates of manifest indicators and latent states, 
with covariances, for specific subjects from data fit with \code{\link{ctStanFit}}, 
based on either the mode (if optimized) or mean (if sampled) of parameter distribution.
}
\examples{
\donttest{

#Basic
ctKalman(ctstantestfit, timerange=c(0,60), plot=TRUE)

#Multiple subjects, y and yprior, showing plot arguments
plot1<-ctKalman(ctstantestfit, timerange=c(0,60), timestep=.1, plot=TRUE,
  subjects=2:3, 
  kalmanvec=c('y','yprior'),
  errorvec=c(NA,'ypriorcov')) #'auto' would also have achieved this
  
 #modify plot as per normal with ggplot
 print(plot1+ggplot2::coord_cartesian(xlim=c(0,10)))
 
 #or generate custom plot from scratch:#'  
 k=ctKalman(ctstantestfit, timerange=c(0,60), timestep=.1, subjects=2:3)
 library(ggplot2)
 ggplot(k[k$Element \%in\% 'yprior',],
   aes(x=Time, y=value,colour=Subject,linetype=Row)) +
   geom_line() +
   theme_bw()

 }
}
