% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{codon_optimize}
\alias{codon_optimize}
\title{Optimize codons}
\usage{
codon_optimize(seq, optimal_codons, gcid = "1")
}
\arguments{
\item{seq}{DNAString, or an object that can be coerced to a DNAString}

\item{optimal_codons}{table optimze codons as generated by \code{est_optimal_codons}}

\item{gcid}{genetic code id, default is '1' (standard genetic code)}
}
\value{
a DNAString of the optimized coding sequence
}
\description{
\code{codon_optimize} takes a coding sequence (without stop codon) and replace
each codon to the corresponding synonymous optimal codon.
}
\examples{
optimal_codons <- est_optimal_codons(yeast_cds)
seq <- 'ATGCTACGA'
codon_optimize(seq, optimal_codons)

}
