% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubble-helper.R
\name{strip_rowwise}
\alias{strip_rowwise}
\title{Remove the rowwise grouping of a cubble}
\usage{
strip_rowwise(data)
}
\arguments{
\item{data}{a cubble object}
}
\value{
a cubble object
}
\description{
Remove the rowwise grouping of a cubble
}
\examples{
library(dplyr)
# row number is not properly added since each row is a separate group
climate_aus |> mutate(.id = row_number())

# proper id after removing the grouping structure
climate_aus |> strip_rowwise() |> mutate(.id = row_number())
}
