% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layout.R
\name{layGrid}
\alias{layGrid}
\title{Use Layout object with grid graphics.}
\usage{
layGrid(grobs, lay, ...)
}
\arguments{
\item{grobs}{list of grobs.}

\item{lay}{a Layout object.}

\item{...}{other parameters passed to \code{\link{grid.arrange}}.}
}
\description{
Use Layout object with grid graphics.
}
\examples{

library(ggplot2)

l1 <- layCreate(matrix(1:2, ncol = 1), heights = c(2, 3))
l2 <- layCreate(matrix(1:2, ncol = 1), heights = c(1, 3))
l3 <- layColBind(l1, l2)

pl1 <- qplot(mpg, wt, data = mtcars)
pl2 <- qplot(mpg, gear, data = mtcars)
pl3 <- qplot(cyl, gear, data = mtcars)
pl4 <- qplot(qsec, am, data = mtcars)

layGrid(list(pl1, pl2, pl3, pl4), l3)

}
