% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metric_boot.R
\name{plot_metric_boot}
\alias{plot_metric_boot}
\title{Plot the bootstrapped metric distribution from a cutpointr object}
\usage{
plot_metric_boot(x, ...)
}
\arguments{
\item{x}{A cutpointr object.}

\item{...}{Additional arguments (unused)}
}
\description{
Given a \code{cutpointr} object this function plots the bootstrapped metric distribution,
i.e. the distribution of out-of-bag metric values.
The metric depends on the function that was supplied to \code{metric} in the
call to \code{cutpointr}.
The \code{cutpointr} function has to be run with \code{boot_runs}` > 0 to enable bootstrapping.
}
\examples{
set.seed(300)
opt_cut <- cutpointr(suicide, dsi, suicide, boot_runs = 10)
plot_metric_boot(opt_cut)
}
\seealso{
Other cutpointr plotting functions: 
\code{\link{plot.cutpointr}()},
\code{\link{plot_cut_boot}()},
\code{\link{plot_cutpointr}()},
\code{\link{plot_metric}()},
\code{\link{plot_precision_recall}()},
\code{\link{plot_roc}()},
\code{\link{plot_sensitivity_specificity}()},
\code{\link{plot_x}()}
}
\concept{cutpointr plotting functions}
