% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{linearShrinkEst}
\alias{linearShrinkEst}
\title{Linear Shrinkage Estimator}
\usage{
linearShrinkEst(dat, alpha)
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}

\item{alpha}{A \code{numeric} between 0 and 1 defining convex combinations
of the sample covariance matrix and the identity. \code{alpha = 1} produces
the sample covariance matrix, and \code{alpha = 0} returns the identity.}
}
\value{
A \code{matrix} corresponding to the estimate of the covariance
matrix.
}
\description{
\code{linearShrinkEst()} computes the linear shrinkage estimate
of the covariance matrix for a given value of \code{alpha}. The linear
shrinkage estimator is defined as the convex combination of the sample
covariance matrix and the identity matrix. The choice of \code{alpha}
determines the bias-variance tradeoff of the estimators in this class:
values near 1 are more likely to exhibit high variance but low bias, and
values near 0 are more likely to be be very biased but have low variance.
}
\examples{
linearShrinkEst(dat = mtcars, alpha = 0.1)
}
