% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sodium.R
\name{keypair_sodium}
\alias{keypair_sodium}
\title{Asymmetric encryption with sodium}
\usage{
keypair_sodium(pub, key, authenticated = TRUE)
}
\arguments{
\item{pub}{A sodium public key.  This is either a raw vector of
length 32 or a path to file containing the contents of the key
(written by \code{\link[=writeBin]{writeBin()}}).}

\item{key}{A sodium private key.  This is either a raw vector of
length 32 or a path to file containing the contents of the key
(written by \code{\link[=writeBin]{writeBin()}}).}

\item{authenticated}{Logical, indicating if authenticated
encryption (via \code{\link[sodium:messaging]{sodium::auth_encrypt()}} /
\code{\link[sodium:messaging]{sodium::auth_decrypt()}}) should be used.  If \code{FALSE}
then \code{\link[sodium:simple]{sodium::simple_encrypt()}} /
\code{\link[sodium:simple]{sodium::simple_decrypt()}} will be used.  The difference is
that with \code{authenticated = TRUE} the message is signed with
your private key so that tampering with the message will be
detected.}
}
\description{
Wrap a pair of sodium keys for asymmetric encryption.  You should
pass your private key and the public key of the person that you
are communicating with.
}
\details{
\emph{NOTE}: the order here (pub, key) is very important; if the
wrong order is used you cannot decrypt things.  Unfortunately
because sodium keys are just byte sequences there is nothing to
distinguish the public and private keys so this is a pretty easy
mistake to make.
}
\examples{

# Generate two keypairs, one for Alice, and one for Bob
key_alice <- sodium::keygen()
pub_alice <- sodium::pubkey(key_alice)
key_bob <- sodium::keygen()
pub_bob <- sodium::pubkey(key_bob)

# Alice wants to send Bob a message so she creates a key pair with
# her private key and bob's public key (she does not have bob's
# private key).
pair_alice <- cyphr::keypair_sodium(pub = pub_bob, key = key_alice)

# She can then encrypt a secret message:
secret <- cyphr::encrypt_string("hi bob", pair_alice)
secret

# Bob wants to read the message so he creates a key pair using
# Alice's public key and his private key:
pair_bob <- cyphr::keypair_sodium(pub = pub_alice, key = key_bob)

cyphr::decrypt_string(secret, pair_bob)
}
\seealso{
\code{\link[=keypair_openssl]{keypair_openssl()}} for a similar function using
openssl keypairs
}
