% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_area}
\alias{po_area}
\title{Area}
\usage{
po_area(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot an area chart.
}
\examples{
if (interactive()) {
  trade_by_continent <- d3po::trade
  trade_by_continent <- aggregate(
    trade ~ year + reporter_continent,
    data = trade_by_continent,
    FUN = sum
  )

  # Assign colors to continents
  my_pal <- tintin::tintin_pal(option = "Cigars of the Pharaoh")(7)

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  d3po(trade_by_continent, width = 800, height = 600) \%>\%
    po_area(daes(
      x = year, y = trade, group = reporter_continent, color = my_pal
    )) \%>\%
    po_labels(
      x = "Year",
      y = "Trade (USD billion)",
      title = "Trade Distribution by Reporter Continent in 2019 and 2023"
    )
}
}
