% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotData}
\alias{plotData}
\title{Plot a list data points}
\usage{
plotData(data, ..., scales = "free", facet = "wrap", transform = NULL)
}
\arguments{
\item{data}{Named list of data.frames as being used in \link{res}, i.e. with columns \code{name}, \code{time}, 
\code{value} and \code{sigma}.}

\item{...}{Further arguments going to \code{subset}.}

\item{scales}{The scales argument of \code{facet_wrap} or \code{facet_grid}, i.e. \code{"free"}, \code{"fixed"}, 
\code{"free_x"} or \code{"free_y"}}

\item{facet}{Either \code{"wrap"} or \code{"grid"}}

\item{transform}{list of transformation for the states, see \link{coordTransform}.}
}
\value{
A plot object of class \code{ggplot}.
}
\description{
Plot a list data points
}
\details{
The data.frame being plotted has columns \code{time}, \code{value}, \code{sigma},
\code{name} and \code{condition}.
}
\examples{
## Observation function
fn <- eqnvec(
  sine = "1 + sin(6.28*omega*time)",
  cosine = "cos(6.28*omega*time)"
)
g <- Y(fn, parameters = "omega")

## Prediction function for time
x <- Xt()

## Parameter transformations to split conditions
p <- NULL
for (i in 1:3) {
  p <- p + P(trafo = c(omega = paste0("omega_", i)), condition = paste0("frequency_", i))
}

## Evaluate prediction
times <- seq(0, 1, .01)
pars <- structure(seq(1, 2, length.out = 3), names = attr(p, "parameters"))

prediction <- (g*x*p)(times, pars)

## Plotting prediction
plot(prediction)
plotPrediction(prediction)
plotPrediction(prediction, scales = "fixed")
plotPrediction(prediction, facet = "grid")
plotPrediction(prediction, 
               scales = "fixed",
               transform = list(sine = "x^2", cosine = "x - 1"))

## Simulate data
dataset <- wide2long(prediction)
dataset <- dataset[seq(1, nrow(dataset), 5),]
dataset$value <- dataset$value + rnorm(nrow(dataset), 0, .1)
dataset$sigma <- 0.1
data <- as.datalist(dataset, split.by = "condition")

## Plotting data
plot(data)
plotData(data)

## Plotting data and prediction with subsetting
plot(prediction, data)
plotCombined(prediction, data)
plotCombined(prediction, data, 
             time <= 0.5 & condition == "frequency_1")
plotCombined(prediction, data, 
             time <= 0.5 & condition != "frequency_1", 
             facet = "grid")
}

