% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{paths}
\alias{paths}
\title{Show Paths}
\usage{
paths(x, from = exposures(x), to = outcomes(x), Z = list(),
  limit = 100, directed = FALSE)
}
\arguments{
\item{x}{the input graph, a DAG, PDAG, or MAG.}

\item{from}{name(s) of first variable(s).}

\item{to}{name(s) of last variable(s).}

\item{Z}{names of variables to condition on for determining open
paths.}

\item{limit}{maximum amount of paths to show. In general, the number of paths grows
exponentially with the number of variables in the graph, such that path inspection
is not useful except for the most simple models.}

\item{directed}{logical; should only directed (i.e., causal) paths 
be shown?}
}
\description{
Returns a list with two compontents: \code{path} gives the actual
paths, and \code{open} shows whether each path is open (d-connected)
or closed (d-separated).
}
\examples{
sum( paths(backDoorGraph(getExample("Shrier")))$open ) # Any open Back-Door paths?

}
