% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{draw_tokens}
\alias{draw_tokens}
\title{Draw token bounding boxes}
\usage{
draw_tokens(
  object,
  type = "sync",
  prefix = NULL,
  dir = getwd(),
  linecol = "red",
  linewd = 3,
  fontcol = "blue",
  fontsize = 4
)
}
\arguments{
\item{object}{either a HTTP response object from
\code{dai_sync()} or the path to a JSON file from
\code{dai_async()}.}

\item{type}{one of "sync" or "async", depending on
the function used to process the original document.}

\item{prefix}{string to be prepended to the output png filename.}

\item{dir}{path to the desired output directory.}

\item{linecol}{color of the bounding box line.}

\item{linewd}{width of the bounding box line.}

\item{fontcol}{color of the box numbers.}

\item{fontsize}{size of the box numbers.}
}
\value{
no return value, called for side effects.
}
\description{
Plots the token (i.e., word) bounding boxes identified
by Document AI (DAI) onto images of the submitted document.
Generates an annotated .png file for each page in the original
document.
}
\details{
Not vectorized, but documents can be multi-page.
}
\examples{
\dontrun{
resp <- dai_sync("page.pdf")
draw_tokens(resp)

draw_tokens("page.json", type = "async")
}
}
