% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_swminmax.R
\name{ts_norm_swminmax}
\alias{ts_norm_swminmax}
\title{Time Series Sliding Window Min-Max}
\usage{
ts_norm_swminmax(remove_outliers = TRUE)
}
\arguments{
\item{remove_outliers}{logical: if TRUE (default) outliers will be removed.}
}
\value{
a \code{ts_norm_swminmax} object.
}
\description{
It takes as parameter the variable remove_outliers. The ts_norm_swminmax function creates an object for normalizing a time series based on the "sliding window min-max scaling" method
}
\examples{
# time series to normalize
data(sin_data)

# convert to sliding windows
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_swminmax()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
