% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_density_class}
\alias{plot_density_class}
\title{Plot density per class}
\usage{
plot_density_class(
  data,
  class_label,
  label_x = "",
  label_y = "",
  colors = NULL,
  bin = NULL,
  alpha = 0.5
)
}
\arguments{
\item{data}{data.frame contain x, value, and variable}

\item{class_label}{name of attribute for class label}

\item{label_x}{x-axis label}

\item{label_y}{y-axis label}

\item{colors}{color vector}

\item{bin}{bin width for density estimation}

\item{alpha}{level of transparency}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
This function generates density plots using ggplot2 grouped by a specified class label from a data frame containing numeric values.
}
\examples{
grf <- plot_density_class(iris |> dplyr::select(Sepal.Width, Species),
class = "Species", colors=c("red", "green", "blue"))
plot(grf)
}
