% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_eigenvalues.R
\name{graph_eigenvalues}
\alias{graph_eigenvalues}
\title{A helper for sub_dann}
\usage{
graph_eigenvalues(xTrain, yTrain,
  neighborhood_size = max(floor(nrow(xTrain)/5), 50), weighted = FALSE,
  sphere = "mcd")
}
\arguments{
\item{xTrain}{Train features. Something easily converted to a numeric matrix.}

\item{yTrain}{Train classes. Something easily converted to a numeric vector.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc]{ncoord}} for details.}

\item{sphere}{sphere argument to ncoord. See \code{\link[fpc]{ncoord}} for details.}
}
\value{
A ggplot graph.
}
\description{
A helper for sub_dann
}
\details{
This function plots the eigenvalues found by \code{\link[fpc]{ncoord}}. The user
should make a judgement call on how many eigenvalues are large and set sub_dann's
numDim to that number.
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)

######################
# Circle data with 2 related variables and 5 unrelated variables
######################
set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train)[1:3] <- c("X1", "X2", "Y")

# Add 5 unrelated variables
train <- train \%>\%
  mutate(
    U1 = runif(300, -1, 1),
    U2 = runif(300, -1, 1),
    U3 = runif(300, -1, 1),
    U4 = runif(300, -1, 1),
    U5 = runif(300, -1, 1)
  )

xTrain <- train \%>\%
  select(X1, X2, U1, U2, U3, U4, U5) \%>\%
  as.matrix()

yTrain <- train \%>\%
  pull(Y) \%>\%
  as.numeric() \%>\%
  as.vector()

# Data suggests a subspace with 2 dimentions. The correct answer.
graph_eigenvalues(xTrain, yTrain, 50, FALSE, "mcd")


rm(train)
rm(xTrain, yTrain)
}
